/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.common.item.ModItems;

public class PhantomInkRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<PhantomInkRecipe> SERIALIZER = new SimpleRecipeSerializer(PhantomInkRecipe::new);

    public PhantomInkRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer var1, @Nonnull Level var2) {
        boolean foundInk = false;
        boolean foundItem = false;
        for (int i = 0; i < var1.m_6643_(); ++i) {
            ItemStack stack = var1.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(ModItems.phantomInk) && !foundInk) {
                foundInk = true;
                continue;
            }
            if (!foundItem) {
                if (stack.m_41720_() instanceof IPhantomInkable && !stack.m_41720_().m_41470_()) {
                    foundItem = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundInk && foundItem;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer var1) {
        ItemStack item = ItemStack.f_41583_;
        for (int i = 0; i < var1.m_6643_(); ++i) {
            ItemStack stack = var1.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof IPhantomInkable) || !item.m_41619_()) continue;
            item = stack;
        }
        IPhantomInkable inkable = (IPhantomInkable)item.m_41720_();
        ItemStack copy = item.m_41777_();
        inkable.setPhantomInk(copy, !inkable.hasPhantomInk(item));
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

